//
//  NSCalendarDate+MCAdditions.h
//  CalendarViewTest
//
//  Created by amohamed on Tue Jul 31 2001.
//  Copyright (c) 2001 Marketcircle Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef enum _MCiCalDayOfWeek {
    MCICAL_NO_WEEKDAY = 0,
    MCICAL_SUNDAY_WEEKDAY,
    MCICAL_MONDAY_WEEKDAY,
    MCICAL_TUESDAY_WEEKDAY,
    MCICAL_WEDNESDAY_WEEKDAY,
    MCICAL_THURSDAY_WEEKDAY,
    MCICAL_FRIDAY_WEEKDAY,
    MCICAL_SATURDAY_WEEKDAY   
} MCiCalDayOfWeek;

typedef enum _MCOffsetType {
	MCMonthOffsetType = 1,
	MCDayOffsetType   = 2,
	MCYearOffsetType  = 3
} MCOffsetType;

typedef enum _MCDayOfWeek {
	MCMonday    = 1,
	MCTuesday   = 2,
	MCWednesday = 4,
	MCThursday  = 8,
	MCFriday    = 16,
	MCSaturday  = 32,
	MCSunday    = 64
} MCDayOfWeek;

typedef enum _MCNSDayOfWeek {
    MCNSSunday = 0,
    MCNSMonday = 1,
    MCNSTuesday = 2,
    MCNSWednesday = 3,
    MCNSThursday = 4,
    MCNSFriday = 5,
    MCNSSaturday = 6
} MCNSDayOfWeek;

typedef enum _MCMonthOfYear {
    MCJanuary = 1,
    MCFebruary = 2,
    MCMarch = 3,
    MCApril = 4,
    MCMay = 5,
    MCJune = 6,
    MCJuly = 7,
    MCAugust = 8,
    MCSeptember = 9,
    MCOctober = 10,
    MCNovember = 11,
    MCDecember = 12
} MCMonthOfYear;

@interface NSObject (MCDateAddition)
- (NSCalendarDate *)rightNow;
@end


@interface NSCalendarDate (MCAdditions)
// uses timeIntervalSinceReferenceDate to create a calendar date from a date (usually NSCFDate)
+ (NSCalendarDate *)calendarDateFromDate:(NSDate *)aDate;

+ (id)dateWithYear:(unsigned int)year month:(unsigned int)month weekOfMonth:(unsigned int)week dayOfWeek:(unsigned int)day hour:(unsigned int)hour minute:(unsigned int)minute second:(unsigned int)second timeZone:(NSTimeZone *)aTimeZone;

+ (id)dateWithYear:(unsigned int)year month:(unsigned int)month weekOfMonth:(unsigned int)week dayOfWeek:(unsigned int)day;

// Returns 2000-10-12 18:00:00 local zone (whatever the current hour is ...)
+ (NSCalendarDate *)dateWithCurrentHour;

// Returns current date time with either 00, 15, 30 or 45 minutes (zero seconds)
// If the current minutes is 05, a date with 00 minutes is returned, if it's 15, 15 is returned, if it's 16, 15 is returned, if it's 31, 30 is retured
+ (NSCalendarDate *)dateWithPreviousClosestQuarterHour;


// Returns a new calendar date with the date values taken from date and the time values taken from time
+ (NSCalendarDate*)dateWithDateFrom: (NSCalendarDate*)date timeFrom: (NSCalendarDate*)time;

- (NSString*)pgStringRepresentation;
-(NSString *)calendarGutterTime;
-(NSString *)calendarGutterRescheduleTime;


- (NSString *)relativeShortDate;
- (NSString *)shortDate;
- (NSString *)shortDateTime;
- (NSString *)shortTime;
- (NSString *)longDate;
- (NSString *)relativeLongDate;
- (NSString *)longDateTime;
- (NSString*)mediumDateTime;
- (NSString*)mediumDate;

+ (NSCalendarDate*)dateWithNaturalLanguageString:(NSString *)dateString locale:(NSDictionary *)aLocale timeZone:(NSTimeZone *)aTimeZone;

- (NSCalendarDate*)dateWithMonth: (int)month;
- (NSCalendarDate*)dateWithDay: (int)day;
- (NSCalendarDate*)dateWithYear: (int)year;

- (NSCalendarDate *)dateByAddingYears:(int)years;
- (NSCalendarDate *)dateByAddingMonths:(int)months;
- (NSCalendarDate*)dateByAddingWeeks:(int)weeks;
- (NSCalendarDate *)dateByAddingDays:(int)days;
- (NSCalendarDate *)dateByAddingMinutes:(int)minutes;
- (NSCalendarDate*)dateByAddingSeconds: (int)seconds;
- (NSCalendarDate *)dateByAddingHours:(int)hours;
- (NSCalendarDate *)dateByAddingHours:(int)hours andMinutes:(int)minutes;

- (NSCalendarDate *)dateByStrippingTime;
- (NSCalendarDate *)dateByStrippingDate;

- (NSInteger)minutesSinceDate:(NSCalendarDate *)date;
- (NSInteger)daysSinceDate:(NSCalendarDate *)date;
- (NSInteger)monthsSinceDate:(NSCalendarDate *)date;

- (int)numberOfDaysInMonth;

//- (NSCalendarDate*)convertedDateToTimeZone: (NSTimeZone*)aTimeZone;

- (int)minutesSinceBeginningOfDay;

- (BOOL)isLaterThanCalendarDate:(NSCalendarDate *)aDate;
- (BOOL)isEarlierThanCalendarDate:(NSCalendarDate *)aDate;
- (BOOL)isSameCalendarDay:(NSCalendarDate *)date;
- (BOOL)isSameCalendarDayTime:(NSCalendarDate*)aDate;

- (BOOL)isEqualToNearestSecondCalendarDate: (NSCalendarDate*)date;

// Returns dates that correspond to the beginning of the day or end of the day
// i.e. if 1999.12.30 14:16 -500 is passed in - it returns 1999.12.30 23:59:59 -500 
// or 1999.12.30 00:00:00 -500
- (NSCalendarDate *)dateAsEndOfDay;
- (NSCalendarDate *)dateAsBeginningOfDay;
- (NSCalendarDate *)dateAsEndOfScheduleDay;
// Returns true if 23:45 or greater
- (BOOL)isEndOfScheduleDay;


- (NSCalendarDate *)nextDay;
- (NSCalendarDate *)previousDay;
- (NSCalendarDate*)dateAsBeginningOfWeekWithWeekStartingDate: (MCDayOfWeek)startOfWeek;
- (NSCalendarDate*)dateAsEndOfWeekWithWeekStartingDate: (MCDayOfWeek)startOfWeek;
- (NSCalendarDate *)dateAsBeginningOfMonth;
- (NSCalendarDate *)dateAsEndOfMonth;
- (int)lastDayOfMonth;
- (NSCalendarDate *)dateAsBeginningOfYear;
- (NSCalendarDate*)dateAsEndOfYear;

// Timezone Specific
- (NSCalendarDate *)dateAsBeginningOfDayInTimeZone:(NSTimeZone *)timeZone;
- (NSCalendarDate *)dateAsEndOfDayInTimeZone:(NSTimeZone *)timeZone;

- (NSCalendarDate *)dateWithOffset:(NSString *)offset skipDays:(NSString *)skipDays;
- (NSCalendarDate *)dateWithOffset:(NSString *)offset;

- (NSArray*)datesForWeekOfDateWithWeekStartingDay: (int)startOfWeek;

- (NSCalendarDate *)dateForWeekOfYear:(unsigned int)weekNumber;

//////////
/// Formatted Values
/////////

- (NSString *)shortMonthDayYear;
- (NSString *)fullMonthDayYear;
- (NSString *)monthDayYear;
- (NSString *)monthDayShortYear;
- (NSString *)dayShortMonthYear;
- (NSString *)dayFullMonthYear;
- (NSString *)dayMonthYear;
- (NSString *)dayMonthShortYear;
- (NSString *)time;
- (NSString *)fullTime;
- (NSString *)militaryTime;
- (NSString *)fullMilitaryTime;
- (NSString *)day;
- (NSString *)weekDay;
- (NSString *)yearDay;
- (NSString *)month;
- (NSString *)shortMonth;
- (NSString *)fullMonth;
- (NSString *)fullYear;
- (NSString *)shortYear;

// Take it's cue from the central format object -- still to be done -- aj Apr 27th, 2002
- (NSString *)preferredDateFormat;
- (NSString *)preferredMediumDateFormat;
- (NSString *)preferredLongDateFormat;
- (NSString *)preferredLongDateTimeFormat;
- (NSString *)preferredTimeFormat;
- (NSString *)preferredDateTimeFormat;

+ (BOOL)prefers24hourTimeFormat;
+ (NSString *)preferredShortTimeFormatString;
+ (NSString *)preferredShortDateFormatString;
+ (NSString *)preferredShortDateTimeFormatString;
+ (NSString *)preferredLongDateFormatString;
+ (NSString *)preferredLongDateTimeFormatString;
+ (NSString*)preferredMediumDateFormatString;
+ (NSString*)preferredMediumDateTimeFormatString;


- (NSString *)evenWeekDayDescription;  // tue, thu or mon, wed, fri
- (NSString *)monthDateDescription; // 28th
- (NSString *)monthWeekDayDescription; // 4th Thursday


- (unsigned int)weekOfMonth;
- (NSUInteger)weekOfYear;
- (unsigned int)gsWeekOfYear;
- (unsigned int)ISO8601WeekOfYear;


- (NSString *)iCalRepresentation;
- (NSString *)iCalDateOnlyRepresentation;

- (NSCalendarDate*)nextDateOccurringOnDaysOfTheWeek:(NSArray*)daysOfTheWeek;
- (NSCalendarDate*)nextDateOccurringOnDaysOfTheMonth:(NSArray*)daysOfTheMonth;
- (NSNumber*)nextMonthOccurringInMonthsOfTheYear:(NSArray*)monthsOfTheYear;

- (BOOL)occursInSameWeekAsDate:(NSCalendarDate*)date2;

+ (BOOL)isValidDateWithDay:(int)aDay month:(int)aMonth year:(int)aYear;
+ (BOOL)isLeapYear:(int)aYear;

+ (NSCalendarDate*)dateWithWeekDay:(int)aDay 
                            inWeek:(int)weekNum 
                           inMonth:(int)aMonth
                            inYear:(int)year;

// monday->sunday... thurs->tuesday
+ (int)futureOffsetBetweenWeekDay1:(int)day1 weekDay2:(int)day2;

// sunday->monday... thurs->tues
+ (int)pastOffsetBetweenWeekDay1:(int)day1 weekDay2:(int)day2;

+ (int)MCNSDayOfWeekForiCalDayOfWeek:(int)aDayOfWeek;
+ (NSString*)MCNSDayOfWeekAsString:(int)dayOfWeek;
+ (NSString*)MCNSDayOfWeekAsFullString:(int)dayOfWeek;
+ (NSString*)MCMonthOfYearAsFullString:(int)monthOfYear;

+ (MCNSDayOfWeek)MCNSDayOfWeekForDayOfWeekFullString:(NSString*)dayOfWeek;
+ (MCMonthOfYear)MCMonthOfYearForMonthOfYearFullString:(NSString*)monthOfYear;

@end




